--Codebase by Yuhiko and his/her mod BodyLocationsTweaker API. All credit of this functionality goes to him/her. 
require "NPCs/BodyLocations" 



local function customGetVal(obj, int) return getClassFieldVal(obj, getClassField(obj, int)); end
local BodyLocationsTweaker = {}; 

BodyLocationsTweaker.group = BodyLocations.getGroup("Human");
BodyLocationsTweaker.list = customGetVal(BodyLocationsTweaker.group, 1); 

function BodyLocationsTweaker:moveOrCreateBeforeOrAfter(toRelocateOrCreate, locationElement, afterBoolean)

    if type(locationElement) ~= "string" then error("Argument 2 is not of type string. Please re-check!", 2); end
    local itemToMoveTo = self.group:getLocation(locationElement); 
    if itemToMoveTo ~= nil then
        
        if type(toRelocateOrCreate) ~= "string" then error("Argument 1 is not of type string. Please re-check!", 2) end
        local curItem = self.group:getOrCreateLocation(toRelocateOrCreate); 
        self.list:remove(curItem); 
        local index = self.group:indexOf(locationElement); 
        if afterBoolean then index = index + 1; end 
        self.list:add(index, curItem); 
        return curItem;
    else 
        error("Could not find the BodyLocation [",locationElement,"] - please check the passed arguments!", 2);
    end
end


function BodyLocationsTweaker:moveOrCreateBefore(toRelocateOrCreate, locationElement) -- for simpler and clearer usage
    return self:moveOrCreateBeforeOrAfter(toRelocateOrCreate, locationElement, false);
end

 BodyLocationsTweaker:moveOrCreateBefore("BathRobeCoat", "BathRobe");
 BodyLocationsTweaker:moveOrCreateBefore("JacketSuitSlim", "JacketSuit");
 
 BodyLocationsTweaker:moveOrCreateBefore("Shoes", "Skirt");

 local group = BodyLocations.getGroup("Human")
			group:setExclusive("FullSuitHead", "BathRobeCoat")
			group:setExclusive("FullSuit", "BathRobeCoat")
			group:setExclusive("FullTop", "BathRobeCoat")
			group:setExclusive("Boilersuit", "BathRobeCoat")
			
			group:setExclusive("BathRobeCoat", "BathRobe")
			
			group:setExclusive("BathRobeCoat", "Sweater")
			group:setExclusive("BathRobeCoat", "SweaterHat")
			group:setExclusive("BathRobeCoat", "Jacket")
			group:setExclusive("BathRobeCoat", "Jacket_Down")
			group:setExclusive("BathRobeCoat", "JacketSuit")
			group:setExclusive("BathRobeCoat", "JacketHat")
			group:setExclusive("BathRobeCoat", "Jacket_Bulky")
			group:setExclusive("BathRobeCoat", "JacketHat_Bulky")
			group:setExclusive("BathRobeCoat", "TorsoExtra")
			group:setExclusive("BathRobeCoat", "TorsoExtraVest")
			group:setExclusive("BathRobeCoat", "Boilersuit")
			group:setExclusive("BodyCostume", "BathRobeCoat")
			
			
			
			group:setExclusive("FullSuit", "JacketSuitSlim")
			group:setExclusive("FullTop", "JacketSuitSlim")
			group:setExclusive("Boilersuit", "JacketSuitSlim")
			
			group:setExclusive("JacketSuitSlim", "JacketSuit")
			
			group:setExclusive("JacketSuitSlim", "Jacket")
			group:setExclusive("JacketSuitSlim", "Jacket_Down")
			group:setExclusive("JacketSuitSlim", "Jacket_Bulky")
			group:setExclusive("JacketSuitSlim", "JacketHat")
			group:setExclusive("JacketSuitSlim", "JacketHat_Bulky")
			group:setExclusive("JacketSuitSlim", "Sweater")
			group:setExclusive("JacketSuitSlim", "SweaterHat")
			group:setExclusive("JacketSuitSlim", "TorsoExtra")
			group:setHideModel("JacketSuitSlim", "FannyPackBack")
